<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsBlog extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-blog';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Blog', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'blog-post' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content_service_post',
			[
				'label' => esc_html__( 'Blog Post', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'background_bg',
			[
				'label'       => esc_html__( 'Background Image', 'bdevs-elementor' ),
				'type'        => Controls_Manager::MEDIA,
				'dynamic'     => [ 'active' => true ],
				'label_block' => true,
				'description' => esc_html__( 'Upload Background Image', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type section title here', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'3'  => esc_html__( '3', 'bdevs-elementor' ),
					'6' => esc_html__( '6', 'bdevs-elementor' ),
					'9' => esc_html__( '9', 'bdevs-elementor' ),
					'12' => esc_html__( '12', 'bdevs-elementor' ),
					'15' => esc_html__( '15', 'bdevs-elementor' ),
					'18' => esc_html__( '18', 'bdevs-elementor' ),
					'21' => esc_html__( '21', 'bdevs-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderpost',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'date'  => esc_html__( 'Date', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'rand' => esc_html__( 'Random', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		$bg_src = wp_get_attachment_image_src( $settings['background_bg']['id'], 'full' );
		$bg_url = $bg_src ? $bg_src[0] : '';
		extract($settings); ?>
<div class="bg-title-area pt-130 pb-130" style="background-image:url(<?php print esc_url( $bg_url ); ?>)">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-8 offset-lg-2 offset-xl-2">
                 <div class="section-title text-center white-title-1 span mr-40 ml-40 mb-75">
                 	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                     <span><i class="far fa-heart-circle"></i> <?php echo wp_kses_post($settings['subheading']); ?></span>
                     <?php endif; ?>	
                     <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                     <h1><?php echo wp_kses_post($settings['heading']); ?></h1>
                     <?php endif; ?>
                 </div>
            </div>
            <div>
                <div class="container">
                    <div class="row">
                    	<?php 
		                $q = new \WP_Query(array(
		                    'post_type'     => 'post',
		                    'posts_per_page'=> $number,
		                    'orderby'       => $orderby,
		                    'order'         => $orderpost,
		                ));
	                    while($q->have_posts()): $q->the_post();  
	                    $image_grid = get_post_meta(get_the_ID(),'_cmb_image_grid', true);
	                    ?>
                        <div class="col-xl-4 col-lg-4 col-md-6">
                            <div class="blog-wrapper mb-30">
                            	<?php if ($image_grid !='')  { ?>
                                <div class="blog-img">
                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($image_grid);?>" alt=""></a>
                                </div>
                                <?php } ?>
                                <div class="blog-content blog-02-content">
                                    <div class="blog-meta">
                                        <span><i class="far fa-calendar-alt"></i> <a><?php the_time(get_option( 'date_format' ));?></a></span>
                                        <span><i class="far fa-comment"></i> <a><?php comments_number( esc_html__('0 Comments', 'moral'), esc_html__('1 Comment', 'moral'), esc_html__('% Comments', 'moral') ); ?></a></span>
                                    </div>
                                    <div class="blog-title">
                                        <h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                    </div>
                                    <p><?php if(isset($fundee_redux_demo['blog_excerpt2'])){?>
                            <?php echo esc_attr(fundee_excerpt2($fundee_redux_demo['blog_excerpt2'])); ?>
                            <?php }else{?>
                            <?php echo esc_attr(fundee_excerpt2(50)); } ?></p>
                                    <a class="btn green-btn" href="<?php the_permalink(); ?>"><?php if(isset($fundee_redux_demo['read_more'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['read_more']));?>
                                <?php }else{?>
                                 <?php echo esc_html__( 'Read More', 'fundee' );?>
                                    <?php } ?><i class="far fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
	<?php
	}
}