<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsContactinfo extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-contact-info';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Contact Infomation', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'newslatter' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_contact-info',
			[
				'label' => esc_html__( 'Contact Info', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Contact Info', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Icon', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'    => 'tab_image2',
						'label'   => esc_html__( 'Image Line', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'text1',
						'label'       => esc_html__( 'Text 1', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Text 1' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'text2',
						'label'       => esc_html__( 'Text 2', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Text 2' , 'bdevs-elementor' ),
						'label_block' => true,
					],	
					
					
				],
			]
		);	
		

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_image',
			[
				'label'   => esc_html__( 'Show Icon', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			
		$this->add_control(
			'show_image2',
			[
				'label'   => esc_html__( 'Show image line', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'show_text1',
			[
				'label'   => esc_html__( 'Show Text 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_text2',
			[
				'label'   => esc_html__( 'Show Text 2', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		$bg_src = wp_get_attachment_image_src( $settings['background_bg']['id'], 'full' );
		$bg_url = $bg_src ? $bg_src[0] : '';
		$bg_src2 = wp_get_attachment_image_src( $settings['background_bg2']['id'], 'full' );
		$bg_url2 = $bg_src2 ? $bg_src2[0] : '';
		?> 
<div class="contact-box-area pt-130 pb-130">
    <div class="container">
        <div class="contact-box-bg">
            <div class="row">
                <?php
		    	$idd = 0;
		    	foreach ( $settings['tabs'] as $item ) :
		    	$idd++;
		        ?>
		        <?php if ( '' !== $item['tab_image'] )  : 
				$image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
				$image = $image_src ? $image_src[0] : ''; 
				?>
				<?php endif; ?>
				<?php if ( '' !== $item['tab_image2'] )  : 
				$image2_src = wp_get_attachment_image_src( $item['tab_image2']['id'], 'full' );
				$image2 = $image2_src ? $image2_src[0] : ''; 
				?>
				<?php endif; ?>
                <div class="col-xl-4 col-lg-4 col-md-6 mb-30">
                    <div class="contact-box-wrapper text-center">
                    	<?php if (( '' !== $item['image'] ) && ( $settings['show_image'] )) : ?>
                        <div class="contact-box-icon-img mb-35">
                            <img src="<?php print esc_url($image); ?>" alt="">
                        </div>
                        <?php endif; ?>
                        <?php if (( '' !== $item['image2'] ) && ( $settings['show_image2'] )) : ?>
                        <div class="contact-box-img">
                            <img src="<?php print esc_url($image2); ?>" alt="">
                         </div>
                        <?php endif; ?>
                         <div class="contact-box-text">
                         	<?php if (( '' !== $item['text1'] ) && ( $settings['show_text1'] )) : ?>
                            <p><?php echo wp_kses_post($item['text1']); ?></p>
                            <?php endif; ?>
                            <?php if (( '' !== $item['text2'] ) && ( $settings['show_text2'] )) : ?>
                            <p><?php echo wp_kses_post($item['text2']); ?></p>
                            <?php endif; ?>
                         </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
	<?php
	}
}