<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsCourses2 extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-courses2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Courses 2', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'Courses 2' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_courses2',
			[
				'label' => esc_html__( 'Courses', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type section title here', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => '6',
			]
		);
		$this->add_control(
			'orderpost',
			[
				'label'     => esc_html__( 'Post Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'date'  => esc_html__( 'Date', 'bdevs-elementor' ),
					'title' => esc_html__( 'Title', 'bdevs-elementor' ),
					'rand' => esc_html__( 'Random', 'bdevs-elementor' ),
				],
				'default'   => 'desc',
			]
		);
		$this->end_controls_section();
		
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$wp_query = new \WP_Query(array('posts_per_page' => $settings['post_number'],'post_type' => 'Courses',  'orderby' => $settings['orderby'], 'order' => $settings['orderpost']));
		extract($settings);?> 
<div class="case-area pt-130 pb-100">
    <div class="container">
    	<?php if (( $settings['show_heading'] ) && ( $settings['show_subheading'] )) : ?>
        <div class="row">
            <div class="col-xl-8 col-lg-8 offset-lg-2 offset-xl-2">
                 <div class="section-title text-center mr-80 ml-80 mb-80">
                 	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                     	<span><i class="far fa-heart-circle"></i><?php echo wp_kses_post($settings['subheading']); ?></span>
                    <?php endif; ?>
                    <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                     	<h1><?php echo wp_kses_post($settings['heading']); ?></h1>
                    <?php endif; ?>
                 </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-xl-12">
               <div class="product-tab-content">
                   <div class="tab-content" id="myTabContent">
                   		<?php 
                        $a = 0;
                            $categories = get_terms('category1');   
                             foreach( (array)$categories as $categorie){
                                $cat_name = $categorie->name;
                                $cat_slug = $categorie->slug;
                                $a++;
                                $class1 = '';
                                if($a == 1){
                                    $class1 = "show active";
                                }
                        ?> 
                        <div class="tab-pane fade <?php echo $class1;?>" id="<?php echo esc_attr($cat_slug);?>" role="tabpanel" aria-labelledby="home-tab">
                            <div class="row">
                            	<?php 
				            $args = new \WP_Query(array(
				            'post_type'     => 'Courses',
				        	));
				            $i = 1;
				            while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
				            $i++;
							?>
							<?php $image = get_post_meta(get_the_ID(),'_cmb_image', true); ?>
							<?php $author = get_post_meta(get_the_ID(),'_cmb_author', true); ?>
							<?php $raise_of = get_post_meta(get_the_ID(),'_cmb_raise_of', true); ?>
							<?php $number01 = get_post_meta(get_the_ID(),'_cmb_number01', true); ?>
							<?php $number02 = get_post_meta(get_the_ID(),'_cmb_number02', true); ?>
							<?php $avatar_author = get_post_meta(get_the_ID(),'_cmb_avatar_author', true); ?>
							<?php $target = get_post_meta(get_the_ID(),'_cmb_target', true); ?>
                                <div class="col-xl-4 col-lg-4 col-md-6">
                                     <div class="case-wrapper white-bg">
					                    <div class="case-img">
					                        <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_attr($image);?>" alt=""></a>
					                    </div>
					                    <div class="case-text">
					                        <h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
					                        <div class="case-name">
					                            <div class="case-say-img">
					                                <img src="<?php echo esc_attr($avatar_author);?>" alt="">
					                            </div>
					                            <div class="case-say-content">
					                                <span><?php echo esc_attr($author);?></span>
					                            </div>
					                            <div class="f-cat f-right">
					                            <?php  $categories = get_the_terms(get_the_ID(),'type');
						                        foreach( (array)$categories as $categorie){
						                        $cat_name = $categorie->name; 
						                        $cat_slug = $categorie->slug;
						                        ?>
						                        <a href="<?php the_permalink(); ?>"><?php echo esc_attr($cat_name);?></a>
							                <?php } ?>
					                            </div>
					                        </div>
					                    </div>
					                    <div class="single-skill mb-25">
					                        <div class="bar-title">
					                            <h5><?php echo esc_attr($number01);?> <span class="raise"><?php echo esc_attr($raise_of);?></span> <span class="used-count"><?php echo esc_attr($number02);?></span></h5>
					                        </div>
					                        <div class="progress">
					                            <div class="progress-bar wow slideInLeft" role="progressbar" style="width: <?php echo esc_attr($target);?>;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" data-wow-duration="1s" data-wow-delay=".5s">
					                                <span><?php echo esc_attr($target);?></span>
					                            </div>
					                        </div>
					                    </div>
					                    <div class="case-info">
					                        <p><?php if(isset($fundee_redux_demo['courses_excerpt'])){?>
					                            <?php echo esc_attr(fundee_excerpt3($fundee_redux_demo['courses_excerpt'])); ?>
					                            <?php }else{?>
					                            <?php echo esc_attr(fundee_excerpt3(15)); } ?></p>
					                        <div class="b-button">
					                            <a href="<?php the_permalink(); ?>"><span><?php if(isset($fundee_redux_demo['donate_now'])){?>
					                                <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['donate_now']));?>
					                                <?php }else{?>
					                                <?php echo esc_html__( 'Donate Now', 'fundee' ); } ?></span> <i class="far fa-long-arrow-right"></i></a>
					                        </div>
					                    </div>
					                </div>
                                </div>
                                <?php endwhile; ?>
                            </div>
                        </div>
                       	<?php } ?>
                   </div>
               </div>
            </div>
        </div>
    </div>
</div>
	<?php
	}
}