<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsFAQS extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-faqs';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'FAQs', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'faqs' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_FAQS',
			[
				'label' => esc_html__( 'Faqs', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is sub heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);		

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);		

		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Description', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'link',
			[
				'label'       => __( 'Link', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Link', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Link', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'button',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Button', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Button', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section_content_faq-right',
			[
				'label' => esc_html__( 'FAQs Items Right', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'FAQs Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'FAQs #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'        => 'title',
						'label'       => esc_html__( ' Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( ' Title Items' , 'bdevs-elementor' ),
						'label_block' => true,
					],				
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle Items', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Subtitle Items' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					
				],
			]
		);

		$this->end_controls_section();
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Text 1', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Subtitle', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		$bg_src = wp_get_attachment_image_src( $settings['background_bg']['id'], 'full' );
		$bg_url = $bg_src ? $bg_src[0] : '';
		$bg_src2 = wp_get_attachment_image_src( $settings['background_bg2']['id'], 'full' );
		$bg_url2 = $bg_src2 ? $bg_src2[0] : '';
		?> 
<div class="faq-area pb-100">
    <div class="container">
        <div class="row">
            <div class="col-xl-6 col-lg-6 mb-30">
                <div class="faq-wrapper">
                    <div class="section-title">
                    	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                        <span><i class="far fa-heart-circle"></i><?php echo wp_kses_post($settings['subheading']); ?></span>
                        <?php endif; ?>
                        <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                        <h1><?php echo wp_kses_post($settings['heading']); ?></h1>
                        <?php endif; ?>
                        <?php if (( '' !== $settings['desc'] ) && ( $settings['show_desc'] )) : ?>
                        <p class="mr-50"><?php echo wp_kses_post($settings['desc']); ?></p>
                        <?php endif; ?>
                    </div>
                    <?php if (( '' !== $settings['button'] ) && ( $settings['show_button'] )) : ?>
                    <div class="faq-button mt-30">
                        <a class="btn" href="<?php echo wp_kses_post($settings['link_button']); ?>"><?php echo wp_kses_post($settings['button']); ?> <i class="far fa-long-arrow-right"></i></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-xl-6 col-lg-6">
                <div class="faq-box mb-30">
                    <div id="accordion">
                    	<?php
				    	$idd = 0;
				    	foreach ( $settings['tabs'] as $item ) :
				    	$idd++;
				        ?>
				        <?php if ( '' !== $item['tab_image'] )  : 
						$image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
						$image = $image_src ? $image_src[0] : ''; 
						?>
						<?php endif; ?>
                        <div class="card">
                        	<?php if (( '' !== $item['title'] ) && ( $settings['show_title'] )) : ?>
                            <div class="card-header" id="heading<?php echo esc_attr($idd);?>">
                            	<?php if ($idd=='1') { ?>
                                <h5 class="mb-0">

                                    <a href="#" class="btn-link" data-toggle="collapse" data-target="#collapse<?php echo esc_attr($idd);?>"
                                        aria-expanded="false" aria-controls="collapse<?php echo esc_attr($idd);?>"><?php echo wp_kses_post($item['title']); ?> </a>
                                </h5>
                                <?php } else { ?>
                                <h5 class="mb-0">
                                    <a href="#" class="btn-link collapsed" data-toggle="collapse" data-target="#collapse<?php echo esc_attr($idd);?>"
                                        aria-expanded="false" aria-controls="collapse<?php echo esc_attr($idd);?>"><?php echo wp_kses_post($item['title']); ?> </a>
                                </h5>
                                <?php } ?>
                            </div>
                            <?php endif; ?>
                            <?php if (( '' !== $item['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
                            <?php if ($idd=='1') { ?>
                            <div class="collapse show" id="collapse<?php echo esc_attr($idd);?>" aria-labelledby="heading<?php echo esc_attr($idd);?>"
                                data-parent="#accordion">
                            <?php } else { ?>
                            <div class="collapse" id="collapse<?php echo esc_attr($idd);?>" aria-labelledby="heading<?php echo esc_attr($idd);?>"
                                data-parent="#accordion">
                            <?php } ?>
                                <div class="card-body">
                                    <p><?php echo wp_kses_post($item['subtitle']); ?></p>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
	<?php
	}
}