<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsPromotect2 extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-promotect2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'promotect 2', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'promotect' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_promotect',
			[
				'label' => esc_html__( 'Promotect', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'background_bg',
			[
				'label'       => esc_html__( 'Background Image Left', 'bdevs-elementor' ),
				'type'        => Controls_Manager::MEDIA,
				'dynamic'     => [ 'active' => true ],
				'label_block' => true,
				'description' => esc_html__( 'Upload Background Image ', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'background_bg2',
			[
				'label'       => esc_html__( 'Background Image Right', 'bdevs-elementor' ),
				'type'        => Controls_Manager::MEDIA,
				'dynamic'     => [ 'active' => true ],
				'label_block' => true,
				'description' => esc_html__( 'Upload Background Image Right', 'bdevs-elementor' ),
			]
		);
		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Heading Left', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading Left', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);		

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your subheading', 'bdevs-elementor' ),
				'default'     => __( 'It is Subheading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);		
		$this->add_control(
			'icon1',
			[
				'label'       => __( 'Icon 1', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Icon 1', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Icon 1', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'title1',
			[
				'label'       => __( 'Title 1', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title 1', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Title 1', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'subtitle1',
			[
				'label'       => __( 'Subtitle 1', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subtitle 1', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Subtitle 1', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'icon2',
			[
				'label'       => __( 'Icon 2', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Icon 2', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Icon 2', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'title2',
			[
				'label'       => __( 'Title 2', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Title 2', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Title 2', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'subtitle2',
			[
				'label'       => __( 'Subtitle 2', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your Subtitle 2', 'bdevs-elementor' ),
				'default'     => __( 'Enter your Subtitle 2', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->end_controls_section();
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);
		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_icon1',
			[
				'label'   => esc_html__( 'Show Icon 1 Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title1',
			[
				'label'   => esc_html__( 'Show Title 1 Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subtitle1',
			[
				'label'   => esc_html__( 'Show Subtitle 1 Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_icon2',
			[
				'label'   => esc_html__( 'Show Icon 2 Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title2',
			[
				'label'   => esc_html__( 'Show Title 2 Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subtitle2',
			[
				'label'   => esc_html__( 'Show Subtitle 2 Right', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		$bg_src = wp_get_attachment_image_src( $settings['background_bg']['id'], 'full' );
		$bg_url = $bg_src ? $bg_src[0] : '';
		$bg_src2 = wp_get_attachment_image_src( $settings['background_bg2']['id'], 'full' );
		$bg_url2 = $bg_src2 ? $bg_src2[0] : '';
	?> 
<div class="promotect-02-area red-bg pos-rel">
    <div class="promotect-bg-img d-none d-md-block" style="background-image:url(<?php print esc_url( $bg_url ); ?>)">
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-6 offset-xl-6 col-lg-6 offset-lg-6">
                <div class="promotect-wrapper promotect-02-wrapper" style="background-image:url(<?php print esc_url( $bg_url2 ); ?>)">
                    <div class="promotect-text">
                    	<?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                        <h1><?php echo wp_kses_post($settings['heading']); ?></h1>
                        <?php endif; ?>
                        <?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                        <p><?php echo wp_kses_post($settings['subheading']); ?></p>
                        <?php endif; ?>
                    </div>
                    <div class="promotect-link">
                        <ul>
                            <li>
                                <?php if (( '' !== $settings['icon1'] ) && ( $settings['show_icon1'] )) : ?>
                                <div class="promotect-2-icon mr-30 f-left">
                                    <i class="<?php echo wp_kses_post($settings['icon1']); ?>"></i>
                                </div>
                                <?php endif; ?>
                                <div class="promotect-2-info">
                                	<?php if (( '' !== $settings['title1'] ) && ( $settings['show_title1'] )) : ?>
                                    <h3><?php echo wp_kses_post($settings['title1']); ?></h3>
                                    <?php endif; ?>
                                    <?php if (( '' !== $settings['subtitle1'] ) && ( $settings['show_subtitle1'] )) : ?>
                                    <p><?php echo wp_kses_post($settings['subtitle1']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </li>
                            <li>
                                <?php if (( '' !== $settings['icon2'] ) && ( $settings['show_icon2'] )) : ?>
                                <div class="promotect-2-icon mr-30 f-left">
                                    <i class="<?php echo wp_kses_post($settings['icon2']); ?>"></i>
                                </div>
                                <?php endif; ?>
                                <div class="promotect-2-info">
                                	<?php if (( '' !== $settings['title2'] ) && ( $settings['show_title2'] )) : ?>
                                    <h3><?php echo wp_kses_post($settings['title2']); ?></h3>
                                    <?php endif; ?>
                                    <?php if (( '' !== $settings['subtitle2'] ) && ( $settings['show_subtitle2'] )) : ?>
                                    <p><?php echo wp_kses_post($settings['subtitle2']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
	<?php
	}
}