<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsTeam extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-team';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Team', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'team' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_Team',
			[
				'label' => esc_html__( 'Team', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your sub heading', 'bdevs-elementor' ),
				'default'     => __( 'It is sub heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);		

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
				'default'     => __( 'It is Heading', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Team', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title'   => esc_html__( 'Slide #1', 'bdevs-elementor' ),
						'tab_content' => esc_html__( 'I am item content. Click edit button to change this text.', 'bdevs-elementor' ),
					]
				],
				'fields' => [
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Image Team', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
						
					],
					[
						'name'        => 'link_face',
						'label'       => esc_html__( 'Link Facebook', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( ' #' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'link_twitter',
						'label'       => esc_html__( 'Link Twitter', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( ' #' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'link_instagram',
						'label'       => esc_html__( 'Link Instagram', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( ' #' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'link_google',
						'label'       => esc_html__( 'Link Google', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( ' #' , 'bdevs-elementor' ),
						'label_block' => true,
					],	
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( ' Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],	
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( ' Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],	
				],
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'center',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);			

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	


		$this->add_control(
			'show_link_face',
			[
				'label'   => esc_html__( 'Show Facebook', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_link_twitter',
			[
				'label'   => esc_html__( 'Show Twitter', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_link_instagram',
			[
				'label'   => esc_html__( 'Show Instagram', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_link_google',
			[
				'label'   => esc_html__( 'Show Google', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		$this->add_control(
			'show_subtitle',
			[
				'label'   => esc_html__( 'Show Subtitle', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		$bg_src = wp_get_attachment_image_src( $settings['background_bg']['id'], 'full' );
		$bg_url = $bg_src ? $bg_src[0] : '';
		$bg_src2 = wp_get_attachment_image_src( $settings['background_bg2']['id'], 'full' );
		$bg_url2 = $bg_src2 ? $bg_src2[0] : '';
		?> 
<div class="team-area pb-100">
    <div class="container">
    	<?php if (( $settings['show_heading'] ) && ( $settings['show_subheading'] )) : ?>
        <div class="row">
            <div class="col-xl-8 col-lg-8 offset-lg-2 offset-xl-2">
                 <div class="section-title text-center mb-80">
                 	<?php if (( '' !== $settings['subheading'] ) && ( $settings['show_subheading'] )) : ?>
                     <span><i class="far fa-heart-circle"></i><?php echo wp_kses_post($settings['subheading']); ?></span>
                     <?php endif; ?>
                     <?php if (( '' !== $settings['heading'] ) && ( $settings['show_heading'] )) : ?>
                     <h1><?php echo wp_kses_post($settings['heading']); ?></h1>
                     <?php endif; ?>
                 </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="row">
        	<?php
        	$idd = 0;
        	foreach ( $settings['tabs'] as $item ) :
        	$idd++;
	        ?>
	        <?php if ( '' !== $item['tab_image'] )  : 
			$image_src = wp_get_attachment_image_src( $item['tab_image']['id'], 'full' );
			$image = $image_src ? $image_src[0] : ''; 
			?>
			<?php endif; ?>
            <div class="col-xl-3 col-lg-3 col-md-6">
                <div class="team-wrapper text-center mb-30">
                    <div class="team-img">
                        <img src="<?php print esc_url($image); ?>" alt="">
                        <div class="team-icon">
                        	<?php if (( '' !== $item['link_face'] ) && ( $settings['show_link_face'] )) : ?>
                            <a href="<?php echo wp_kses_post($item['link_face']); ?>" tabindex="0"><i class="fab fa-facebook-f"></i></a>
                            <?php endif; ?>
                            <?php if (( '' !== $item['link_twitter'] ) && ( $settings['show_link_twitter'] )) : ?>
                            <a href="<?php echo wp_kses_post($item['link_twitter']); ?>" tabindex="0"><i class="fab fa-twitter"></i></a>
                            <?php endif; ?>
                            <?php if (( '' !== $item['link_instagram'] ) && ( $settings['show_link_instagram'] )) : ?>
                            <a href="<?php echo wp_kses_post($item['link_instagram']); ?>" tabindex="0"><i class="fab fa-instagram"></i></a>
                            <?php endif; ?>
                            <?php if (( '' !== $item['link_google'] ) && ( $settings['show_link_google'] )) : ?>
                            <a href="<?php echo wp_kses_post($item['link_google']); ?>" tabindex="0"><i class="fab fa-google"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="team-text">
                    	<?php if (( '' !== $item['title'] ) && ( $settings['show_title'] )) : ?>
                        <h3><?php echo wp_kses_post($item['title']); ?></h3>
                        <?php endif; ?>
                        <?php if (( '' !== $item['subtitle'] ) && ( $settings['show_subtitle'] )) : ?>
                        <span><?php echo wp_kses_post($item['subtitle']); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            
        </div>
    </div>
</div>
	<?php
	}
}