<?php
/**
 * Include and setup custom metaboxes and fields.
 *
 * @category YourThemeOrPlugin
 * @package  Metaboxes
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/jaredatch/Custom-Metaboxes-and-Fields-for-WordPress
 */

add_filter( 'cmb_meta_boxes', 'cmb_sample_metaboxes' );
/**
 * Define the metabox and field configurations.
 *
 * @param  array $meta_boxes
 * @return array
 */
$textdomain = "fundee";
function cmb_sample_metaboxes( array $meta_boxes ) {

	// Start with an underscore to hide fields from custom fields list
	$prefix = '_cmb_';
	
  
   
    // Add other metaboxes as needed
    
    $meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('post'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Title Recent Posts',
                'desc' => 'Title Recent Posts',
                'id'   => $prefix . 'title_recent',
                'type'    => 'text',
            ),
            array(
                'name' => 'Image Recent Posts',
                'desc' => 'Background Projects Details',
                'id'   => $prefix . 'img_recent',
                'type'    => 'file',
            ),
            array(
                'name' => 'Image Blog Grid',
                'desc' => 'Background Blog Grid',
                'id'   => $prefix . 'image_grid',
                'type'    => 'file',
            ),
            array(
                'name' => 'Video',
                'desc' => 'Link Video',
                'default' => '',
                'id' => $prefix . 'single_video',
                'type' => 'text'
            ),
            array(
                'name' => 'Audio',
                'desc' => 'Link audio',
                'default' => '',
                'id' => $prefix . 'single_audio',
                'type' => 'textarea'
            ),

        )
    );

$meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('Event'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
            array(
                'name' => 'Image Page Home',
                'desc' => 'Image Page Home',
                'id'   => $prefix . 'image',
                'type'    => 'file',
            ),
            array(
                'name' => 'Event Date',
                'desc' => 'Event Date',
                'id'   => $prefix . 'event_date',
                'type'    => 'text',
            ),
            array(
                'name' => 'Time Event Date',
                'desc' => 'Time Event Date',
                'id'   => $prefix . 'time_event_date',
                'type'    => 'text',
            ),
            array(
                'name' => 'Address Event',
                'desc' => 'Address Event',
                'id'   => $prefix . 'address_event',
                'type'    => 'text',
            ),
            array(
                'name' => 'Seat Event',
                'desc' => 'Seat Event',
                'id'   => $prefix . 'seat_event',
                'type'    => 'text',
            ),
        )
    );




$meta_boxes[] = array(
        'id'         => 'post_setting',
        'title'      => 'Post Setting',
        'pages'      => array('Courses'), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox
        'fields' => array(
         
            
            array(
                'name' => 'Background Image Home page',
                'desc' => 'Background Image Home page',
                'id'   => $prefix . 'image',
                'type'    => 'file',
            ),
            array(
                'name' => 'Name Author',
                'desc' => 'Name Author',
                'id'   => $prefix . 'author',
                'type'    => 'text',
            ),
            array(
                'name' => 'Avatar Author',
                'desc' => 'Avatar Author',
                'id'   => $prefix . 'avatar_author',
                'type'    => 'file',
            ),
            array(
                'name' => 'Number 01',
                'desc' => 'Number 01',
                'id'   => $prefix . 'number01',
                'type'    => 'text',
            ),
            array(
                'name' => 'Raise Of',
                'desc' => 'Raise Of',
                'id'   => $prefix . 'raise_of',
                'type'    => 'text',
            ),array(
                'name' => 'Number 02',
                'desc' => 'Number 02',
                'id'   => $prefix . 'number02',
                'type'    => 'text',
            ),
            array(
                'name' => 'Target',
                'desc' => 'Target (0%...100%)',
                'id'   => $prefix . 'target',
                'type'    => 'text',
            ),
            array(
                'name' => 'Background Image Project',
                'desc' => 'Background Image Project',
                'id'   => $prefix . 'image_project',
                'type'    => 'file',
            ),
            array(
                'name' => 'Title Project',
                'desc' => 'Title Project',
                'id'   => $prefix . 'title_project',
                'type'    => 'text',
            ),
            array(
                'name' => 'Subtitle Project',
                'desc' => 'Subtitle Project',
                'id'   => $prefix . 'subtitle_project',
                'type'    => 'text',
            ),
        )
    );


    return $meta_boxes;
}

add_action( 'init', 'cmb_initialize_cmb_meta_boxes', 9999 );
/**
 * Initialize the metabox class.
 */
function cmb_initialize_cmb_meta_boxes() {

	if ( ! class_exists( 'cmb_Meta_Box' ) )
		require_once 'init.php';

} 