<?php
// register post type Courses
add_action( 'init', 'register_fundee_Courses' );
function register_fundee_Courses() {
    
$labels = array( 
'name' => __( 'Courses', 'fundee' ),
'singular_name' => __( 'Courses', 'fundee' ),
'add_new' => __( 'Add New Courses', 'fundee' ),
'add_new_item' => __( 'Add New Courses', 'fundee' ),
'edit_item' => __( 'Edit Courses', 'fundee' ),
'new_item' => __( 'New Courses', 'fundee' ),
'view_item' => __( 'View Courses', 'fundee' ),
'search_items' => __( 'Search Courses', 'fundee' ),
'not_found' => __( 'No Courses found', 'fundee' ),
'not_found_in_trash' => __( 'No Courses found in Trash', 'fundee' ),
'parent_item_colon' => __( 'Parent Courses:', 'fundee' ),
'menu_name' => __( 'Courses', 'fundee' ),
);

$args = array( 
'labels' => $labels,
'hierarchical' => true,
'description' => 'List Courses',
'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
'taxonomies' => array( 'Courses', 'type', 'category1' ),
'public' => true,
'show_ui' => true,
'show_in_menu' => true,
'menu_position' => 5,
'menu_icon' => 'dashicons-universal-access', 
'show_in_nav_menus' => true,
'publicly_queryable' => true,
'exclude_from_search' => false,
'has_archive' => true,
'query_var' => true,
'can_export' => true,
'rewrite' => true,
'capability_type' => 'post'
);

register_post_type( 'Courses', $args );
}
add_action( 'init', 'create_Type_hierarchical_taxonomy', 0 );
add_action( 'init', 'create_Category1_hierarchical_taxonomy', 0 );
//create a custom taxonomy name it Skillss for your posts

function create_Type_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

$labels = array(
'name' => __( 'Type', 'fundee' ),
'singular_name' => __( 'Type', 'fundee' ),
'search_items' =>  __( 'Search Type','fundee' ),
'all_items' => __( 'All Type','fundee' ),
    'parent_item' => __( 'Parent Type','fundee' ),
    'parent_item_colon' => __( 'Parent Type:','fundee' ),
    'edit_item' => __( 'Edit Type','fundee' ), 
    'update_item' => __( 'Update Type','fundee' ),
    'add_new_item' => __( 'Add New Type','fundee' ),
    'new_item_name' => __( 'New Type Name','fundee' ),
    'menu_name' => __( 'Type','fundee' ),
  );     

// Now register the taxonomy

  register_taxonomy('type',array('Courses'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type' ),
  ));

}
function create_Category1_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

$labels = array(
'name' => __( 'Category', 'fundee' ),
'singular_name' => __( 'Category', 'fundee' ),
'search_items' =>  __( 'Search Category','fundee' ),
'all_items' => __( 'All Category','fundee' ),
    'parent_item' => __( 'Parent Category','fundee' ),
    'parent_item_colon' => __( 'Parent Category:','fundee' ),
    'edit_item' => __( 'Edit Category','fundee' ), 
    'update_item' => __( 'Update Category','fundee' ),
    'add_new_item' => __( 'Add New Category','fundee' ),
    'new_item_name' => __( 'New Category Name','fundee' ),
    'menu_name' => __( 'Category','fundee' ),
  );     

// Now register the taxonomy

  register_taxonomy('category1',array('Courses'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'category1' ),
  ));

}

add_action( 'init', 'register_fundee_Event' );
function register_fundee_Event() {
    
$labels = array( 
'name' => __( 'Event', 'fundee' ),
'singular_name' => __( 'Event', 'fundee' ),
'add_new' => __( 'Add New Event', 'fundee' ),
'add_new_item' => __( 'Add New Event', 'fundee' ),
'edit_item' => __( 'Edit Event', 'fundee' ),
'new_item' => __( 'New Event', 'fundee' ),
'view_item' => __( 'View Event', 'fundee' ),
'search_items' => __( 'Search Event', 'fundee' ),
'not_found' => __( 'No Event found', 'fundee' ),
'not_found_in_trash' => __( 'No Event found in Trash', 'fundee' ),
'parent_item_colon' => __( 'Parent Event:', 'fundee' ),
'menu_name' => __( 'Event', 'fundee' ),
);

$args = array( 
'labels' => $labels,
'hierarchical' => true,
'description' => 'List Event',
'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),
'taxonomies' => array( 'Event', 'type1' ),
'public' => true,
'show_ui' => true,
'show_in_menu' => true,
'menu_position' => 5,
'menu_icon' => 'dashicons-id-alt', 
'show_in_nav_menus' => true,
'publicly_queryable' => true,
'exclude_from_search' => false,
'has_archive' => true,
'query_var' => true,
'can_export' => true,
'rewrite' => true,
'capability_type' => 'post'
);

register_post_type( 'Event', $args );
}
add_action( 'init', 'create_Type1_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it Skillss for your posts

function create_Type1_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like Skills
//first do the translations part for GUI

$labels = array(
'name' => __( 'Type1', 'fundee' ),
'singular_name' => __( 'Type1', 'fundee' ),
'search_items' =>  __( 'Search Type1','fundee' ),
'all_items' => __( 'All Type1','fundee' ),
    'parent_item' => __( 'Parent Type1','fundee' ),
    'parent_item_colon' => __( 'Parent Type1:','fundee' ),
    'edit_item' => __( 'Edit Type1','fundee' ), 
    'update_item' => __( 'Update Type1','fundee' ),
    'add_new_item' => __( 'Add New Type1','fundee' ),
    'new_item_name' => __( 'New Type1 Name','fundee' ),
    'menu_name' => __( 'Type1','fundee' ),
  );     

// Now register the taxonomy

  register_taxonomy('type1',array('Event'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'type1' ),
  ));

}


?>