<?php
$faithful_slider_sc = faithful_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $faithful_slider_sc ) && strpos( $faithful_slider_sc, '[' ) !== false && strpos( $faithful_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( faithful_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$faithful_anchor_icon = faithful_get_theme_option( 'front_page_title_anchor_icon' );
		$faithful_anchor_text = faithful_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $faithful_anchor_icon ) || ! empty( $faithful_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $faithful_anchor_icon ) ? ' icon="' . esc_attr( $faithful_anchor_icon ) . '"' : '' )
									. ( ! empty( $faithful_anchor_text ) ? ' title="' . esc_attr( $faithful_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $faithful_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$faithful_scheme = faithful_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $faithful_scheme ) && ! faithful_is_inherit( $faithful_scheme ) ) {
			echo ' scheme_' . esc_attr( $faithful_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( faithful_get_theme_option( 'front_page_title_paddings' ) );
		if ( faithful_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$faithful_css      = '';
		$faithful_bg_image = faithful_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $faithful_bg_image ) ) {
			$faithful_css .= 'background-image: url(' . esc_url( faithful_get_attachment_url( $faithful_bg_image ) ) . ');';
		}
		if ( ! empty( $faithful_css ) ) {
			echo ' style="' . esc_attr( $faithful_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$faithful_anchor_icon = faithful_get_theme_option( 'front_page_title_anchor_icon' );
		$faithful_anchor_text = faithful_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $faithful_anchor_icon ) || ! empty( $faithful_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $faithful_anchor_icon ) ? ' icon="' . esc_attr( $faithful_anchor_icon ) . '"' : '' )
									. ( ! empty( $faithful_anchor_text ) ? ' title="' . esc_attr( $faithful_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( faithful_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' faithful-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$faithful_css      = '';
			$faithful_bg_mask  = faithful_get_theme_option( 'front_page_title_bg_mask' );
			$faithful_bg_color_type = faithful_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $faithful_bg_color_type ) {
				$faithful_bg_color = faithful_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $faithful_bg_color_type ) {
				$faithful_bg_color = faithful_get_scheme_color( 'bg_color', $faithful_scheme );
			} else {
				$faithful_bg_color = '';
			}
			if ( ! empty( $faithful_bg_color ) && $faithful_bg_mask > 0 ) {
				$faithful_css .= 'background-color: ' . esc_attr(
					1 == $faithful_bg_mask ? $faithful_bg_color : faithful_hex2rgba( $faithful_bg_color, $faithful_bg_mask )
				) . ';';
			}
			if ( ! empty( $faithful_css ) ) {
				echo ' style="' . esc_attr( $faithful_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$faithful_caption = faithful_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $faithful_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $faithful_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $faithful_caption, 'faithful_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$faithful_description = faithful_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $faithful_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $faithful_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $faithful_description ), 'faithful_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( faithful_get_theme_option( 'front_page_title_button1_link' ) != '' || faithful_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						faithful_show_layout( faithful_customizer_partial_refresh_front_page_title_button1_link() );
						faithful_show_layout( faithful_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
