<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

$faithful_template = apply_filters( 'faithful_filter_get_template_part', faithful_blog_archive_get_template() );

if ( ! empty( $faithful_template ) && 'index' != $faithful_template ) {

	get_template_part( $faithful_template );

} else {

	faithful_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$faithful_stickies   = is_home()
								|| ( in_array( faithful_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) faithful_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$faithful_post_type  = faithful_get_theme_option( 'post_type' );
		$faithful_args       = array(
								'blog_style'     => faithful_get_theme_option( 'blog_style' ),
								'post_type'      => $faithful_post_type,
								'taxonomy'       => faithful_get_post_type_taxonomy( $faithful_post_type ),
								'parent_cat'     => faithful_get_theme_option( 'parent_cat' ),
								'posts_per_page' => faithful_get_theme_option( 'posts_per_page' ),
								'sticky'         => faithful_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $faithful_stickies )
															&& count( $faithful_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		faithful_blog_archive_start();

		do_action( 'faithful_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'faithful_action_before_page_author' );
			get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'faithful_action_after_page_author' );
		}

		if ( faithful_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'faithful_action_before_page_filters' );
			faithful_show_filters( $faithful_args );
			do_action( 'faithful_action_after_page_filters' );
		} else {
			do_action( 'faithful_action_before_page_posts' );
			faithful_show_posts( array_merge( $faithful_args, array( 'cat' => $faithful_args['parent_cat'] ) ) );
			do_action( 'faithful_action_after_page_posts' );
		}

		do_action( 'faithful_action_blog_archive_end' );

		faithful_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
