<?php
/**
 * Required plugins
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
if ( ! function_exists( 'faithful_skin_required_plugins' ) ) {
	add_action( 'after_setup_theme', 'faithful_skin_required_plugins', -1 );
	function faithful_skin_required_plugins() {
		$faithful_theme_required_plugins_groups = array(
			'core'          => esc_html__( 'Core', 'faithful' ),
			'page_builders' => esc_html__( 'Page Builders', 'faithful' ),
			'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'faithful' ),
			'socials'       => esc_html__( 'Socials and Communities', 'faithful' ),
			'events'        => esc_html__( 'Events and Appointments', 'faithful' ),
			'content'       => esc_html__( 'Content', 'faithful' ),
			'other'         => esc_html__( 'Other', 'faithful' ),
		);
		$faithful_theme_required_plugins        = array(
			// Core
			'trx_addons'                 => array(
				'title'       => esc_html__( 'ThemeREX Addons', 'faithful' ),
				'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'faithful' ),
				'required'    => true, // Check this plugin in the list on load Theme Dashboard
				'logo'        => 'trx_addons.png',
				'group'       => $faithful_theme_required_plugins_groups['core'],
			),
			// Page Builders
			'elementor'                  => array(
				'title'       => esc_html__( 'Elementor', 'faithful' ),
				'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'faithful' ),
				'required'    => false, // Leave this plugin unchecked on load Theme Dashboard
				'logo'        => 'elementor.png',
				'group'       => $faithful_theme_required_plugins_groups['page_builders'],
			),
			'gutenberg'                  => array(
				'title'       => esc_html__( 'Gutenberg', 'faithful' ),
				'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'faithful' ),
				'required'    => false,
				'install'     => false, // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'gutenberg.png',
				'group'       => $faithful_theme_required_plugins_groups['page_builders'],
			),
			// Events
			'the-events-calendar'        => array(
				'title'       => esc_html__( 'The Events Calendar', 'faithful' ),
				'description' => '',
				'required'    => false,
				'logo'        => 'the-events-calendar.png',
				'group'       => $faithful_theme_required_plugins_groups['events'],
			),
			'event-tickets'              => array(
				'title'       => esc_html__( 'Event Tickets', 'faithful' ),
				'description' => '',
				'required'    => false,
				'logo'        => 'event-tickets.png',
				'group'       => $faithful_theme_required_plugins_groups['events'],
			),
			// E-Commerce & Donations
			'give'                       => array(
				'title'       => esc_html__( 'Give', 'faithful' ),
				'description' => '',
				'required'    => false,
				'logo'        => 'give.png',
				'group'       => $faithful_theme_required_plugins_groups['ecommerce'],
			),
			// Content
			'sitepress-multilingual-cms' => array(
				'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'faithful' ),
				'description' => esc_html__( "Allows you to make your website multilingual", 'faithful' ),
				'required'    => false,
				'install'     => false, // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'sitepress-multilingual-cms.png',
				'group'       => $faithful_theme_required_plugins_groups['content'],
			),
			'metform'                    => array(
				'title'       => esc_html__( 'MetForm', 'faithful' ),
				'description' => esc_html__( "Contact Form, Survey, Quiz, & Custom Form Builder for Elementor", 'faithful' ),
				'required'    => false,
				'logo'        => 'metform.png',
				'group'       => $faithful_theme_required_plugins_groups['content'],
			),
			// Other
			'trx_updater'                => array(
				'title'       => esc_html__( 'ThemeREX Updater', 'faithful' ),
				'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'faithful' ),
				'required'    => false,
				'logo'        => 'trx_updater.png',
				'group'       => $faithful_theme_required_plugins_groups['other'],
			)
		);

		if ( FAITHFUL_THEME_FREE ) {
			unset( $faithful_theme_required_plugins['sitepress-multilingual-cms'] );
			unset( $faithful_theme_required_plugins['trx_updater'] );
		}

		// Add plugins list to the global storage
		faithful_storage_set( 'required_plugins', $faithful_theme_required_plugins );
	}
}
