<?php
/**
 * The template to display Admin notices
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0.1
 */

$faithful_theme_slug = get_template();
$faithful_theme_obj  = wp_get_theme( $faithful_theme_slug );
?>
<div class="faithful_admin_notice faithful_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$faithful_theme_img = faithful_get_file_url( 'screenshot.jpg' );
	if ( '' != $faithful_theme_img ) {
		?>
		<div class="faithful_notice_image"><img src="<?php echo esc_url( $faithful_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'faithful' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="faithful_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'faithful' ),
				$faithful_theme_obj->get( 'Name' ) . ( FAITHFUL_THEME_FREE ? ' ' . __( 'Free', 'faithful' ) : '' ),
				$faithful_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="faithful_notice_text">
		<p class="faithful_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $faithful_theme_obj->description ) );
			?>
		</p>
		<p class="faithful_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'faithful' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="faithful_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=faithful_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'faithful' );
			?>
		</a>
	</div>
</div>
