<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( faithful_is_on( faithful_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( faithful_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( faithful_is_on( faithful_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$faithful_mult = faithful_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $faithful_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( faithful_is_on( faithful_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$faithful_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $faithful_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( faithful_is_on( faithful_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $faithful_author_description ), 'faithful_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$faithful_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );	// get_the_author_posts() return posts number by post_type from first post in the result
			if ( $faithful_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $faithful_posts_total, 'faithful' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $faithful_posts_total ) . '</span>'
								 		),
							'faithful_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'faithful' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'faithful_action_user_meta', 'author-page' );
			$faithful_socials = ob_get_contents();
			ob_end_clean();
			faithful_show_layout( $faithful_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'faithful' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
