<?php
/**
 * The template to display default site footer
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0.10
 */

$faithful_footer_id = faithful_get_custom_footer_id();
$faithful_footer_meta = faithful_get_custom_layout_meta( $faithful_footer_id );
if ( ! empty( $faithful_footer_meta['margin'] ) ) {
	faithful_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( faithful_prepare_css_value( $faithful_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $faithful_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $faithful_footer_id ) ) ); ?>">
	<?php
	// Custom footer's layout
	do_action( 'faithful_action_show_layout', $faithful_footer_id );
	?>
</footer>