<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0.10
 */

// Footer sidebar
$faithful_footer_name    = faithful_get_theme_option( 'footer_widgets' );
$faithful_footer_present = ! faithful_is_off( $faithful_footer_name ) && is_active_sidebar( $faithful_footer_name );
if ( $faithful_footer_present ) {
	faithful_storage_set( 'current_sidebar', 'footer' );
	ob_start();
	if ( is_active_sidebar( $faithful_footer_name ) ) {
		dynamic_sidebar( $faithful_footer_name );
	}
	$faithful_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $faithful_out ) ) {
		$faithful_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $faithful_out );
		$faithful_need_columns = true;   //or check: strpos($faithful_out, 'columns_wrap')===false;
		if ( $faithful_need_columns ) {
			$faithful_columns = max( 0, (int) faithful_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $faithful_columns ) {
				$faithful_columns = min( 4, max( 1, faithful_tags_count( $faithful_out, 'aside' ) ) );
			}
			if ( $faithful_columns > 1 ) {
				$faithful_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $faithful_columns ) . ' widget', $faithful_out );
			} else {
				$faithful_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area sc_layouts_row">
			<?php do_action( 'faithful_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<div class="content_wrap">
					<?php
					if ( $faithful_need_columns ) {
						?>
						<div class="columns_wrap">
						<?php
					}
					do_action( 'faithful_action_before_sidebar', 'footer' );
					faithful_show_layout( $faithful_out );
					do_action( 'faithful_action_after_sidebar', 'footer' );
					if ( $faithful_need_columns ) {
						?>
						</div>
						<?php
					}
					?>
				</div>
			</div>
			<?php do_action( 'faithful_action_after_sidebar_wrap', 'footer' ); ?>
		</div>
		<?php
	}
}
