<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0.06
 */

$faithful_header_css   = '';
$faithful_header_image = get_header_image();
if ( ! empty( $faithful_header_image ) && faithful_trx_addons_featured_image_override( faithful_is_singular() || faithful_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$faithful_header_image = faithful_get_current_mode_image( $faithful_header_image );
}

$faithful_header_id = faithful_get_custom_header_id();
$faithful_header_meta = faithful_get_custom_layout_meta( $faithful_header_id );
if ( ! empty( $faithful_header_meta['margin'] ) ) {
	faithful_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( faithful_prepare_css_value( $faithful_header_meta['margin'] ) ) ) );
	faithful_storage_set( 'custom_header_margin', faithful_prepare_css_value( $faithful_header_meta['margin'] ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $faithful_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $faithful_header_id ) ) ); ?>
				<?php
				echo ! empty( $faithful_header_image )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $faithful_header_image ) {
					echo ' ' . esc_attr( faithful_add_inline_css_class( 'background-image: url(' . esc_url( $faithful_header_image ) . ');' ) );
				}
				if ( faithful_is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				?>
">
	<?php

	// Custom header's layout
	do_action( 'faithful_action_show_layout', $faithful_header_id );

	?>
</header>
