<?php
/**
 * The template to display default site header
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

$faithful_header_css   = '';
$faithful_header_image = get_header_image();
$faithful_header_video = faithful_get_header_video();
if ( ! empty( $faithful_header_image ) && faithful_trx_addons_featured_image_override( faithful_is_singular() || faithful_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$faithful_header_image = faithful_get_current_mode_image( $faithful_header_image );
}
?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $faithful_header_image ) || ! empty( $faithful_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $faithful_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $faithful_header_image ) {
		echo ' ' . esc_attr( faithful_add_inline_css_class( 'background-image: url(' . esc_url( $faithful_header_image ) . ');' ) );
	}
	if ( faithful_is_singular() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $faithful_header_video ) ) {
		get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/header-navi' ) );

	// Page title and breadcrumbs area
	if ( ! faithful_is_single() ) {
		get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/header-title' ) );
	}
	?>
</header>
