<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
 $fundee_redux_demo = get_option('redux_demo');
get_header(); ?> 
<?php if(isset($fundee_redux_demo['404_image']['url']) && $fundee_redux_demo['404_image']['url'] != ''){?>
<section class="breadcrumb-area" style="background-image:url(<?php echo esc_url($fundee_redux_demo['404_image']['url']); ?>)">
<?php }else{?>
<section class="breadcrumb-area" style="background-image:url(<?php echo get_template_directory_uri();?>/img/bg/contractbg.jpg)">
<?php } ?>   
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="breadcrumb-text text-center">
                    <h1><?php if(isset($fundee_redux_demo['error_page'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['error_page']));?>
                                    <?php }else{?>
                                    <?php echo esc_html__( 'Error Page', 'fundee' );
                                    }
                                    ?></h1>
                    <ul class="breadcrumb-menu">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'fundee' );?></a></li>
                        <li><span><?php if(isset($fundee_redux_demo['error_page'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['error_page']));?>
                                    <?php }else{?>
                                    <?php echo esc_html__( 'Error Page', 'fundee' );
                                    }
                                    ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
    <!--End Page Title-->

    <!--Error Section-->
    <section class="error-section">
        <div class=" auto-container">
        <div class="col-xl-12 text-center">
            <div class=" error-title"><?php if(isset($fundee_redux_demo['404'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['404']));?>
                                    <?php }else{?>
                                    <?php echo esc_html__( '404', 'fundee' );
                                    }
                                    ?></div>
            <h4><?php if(isset($fundee_redux_demo['page_not_found'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['page_not_found']));?>
                                    <?php }else{?>
                                    <?php echo esc_html__( 'Page not Found', 'fundee' );
                                    }
                                    ?></h4>
            <div class="text"><?php if(isset($fundee_redux_demo['desc'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['desc']));?>
                                    <?php }else{?>
                                    <?php echo esc_html__( 'Sorry, we could not find the page you are looking for', 'fundee' );
                                    }
                                    ?></div>
            <a href="<?php echo esc_url(home_url('/')); ?>" class="theme-btn btn-style-three"><span class="btn btn-grad"><?php if(isset($fundee_redux_demo['home_page'])){?>
                                    <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['home_page']));?>
                                    <?php }else{?>
                                    <?php echo esc_html__( 'Go To Home Page', 'fundee' );
                                    }
                                    ?></span></a>
        </div>
        </div>
    </section>
<?php
get_footer(); ?> 
