<?php
$fundee_redux_demo = get_option('redux_demo');

//Custom fields:
require_once get_template_directory() . '/framework/wp_bootstrap_navwalker.php';
require_once get_template_directory() . '/framework/widget/recent-post.php';
//Theme Set up:
function fundee_theme_setup() {
    /*
     * This theme uses a custom image size for featured images, displayed on
     * "standard" posts and pages.
     */
  	add_theme_support( 'custom-header' ); 
  	add_theme_support( 'custom-background' );
  	$lang = get_template_directory_uri() . '/languages';
    load_theme_textdomain('fundee', $lang);
    add_theme_support( 'post-thumbnails' );
    // Adds RSS feed links to <head> for posts and comments.
    add_theme_support( 'automatic-feed-links' );
    // Switches default core markup for search form, comment form, and comments
    // to output valid HTML5.
    add_theme_support( "title-tag" );
    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
    // This theme uses wp_nav_menu() in one location.
  	register_nav_menus( array(
      'primary' =>  esc_html__( 'Primary Navigation Menu: Chosen menu in  pages ...', 'fundee' ),
  	) );
      // This theme uses its own gallery styles.
}
add_action( 'after_setup_theme', 'fundee_theme_setup' );
if ( ! isset( $content_width ) ) $content_width = 900;
function fundee_theme_scripts_styles() {
  	$fundee_redux_demo = get_option('redux_demo');
  	$protocol = is_ssl() ? 'https' : 'http';
    wp_enqueue_style( 'bootstrap', get_template_directory_uri().'/assets/css/bootstrap.min.css');
    wp_enqueue_style( 'owl-carousel', get_template_directory_uri().'/assets/css/owl.carousel.min.css');
    wp_enqueue_style( 'animate', get_template_directory_uri().'/assets/css/animate.min.css');
    wp_enqueue_style( 'magnific-popup', get_template_directory_uri().'/assets/css/magnific-popup.css');
    wp_enqueue_style( 'fontawesome-all', get_template_directory_uri().'/assets/css/fontawesome-all.min.css');
    wp_enqueue_style( 'fundee-themify-icons', get_template_directory_uri().'/assets/css/themify-icons.css');
    wp_enqueue_style( 'fundee-meanmenu', get_template_directory_uri().'/assets/css/meanmenu.css');
    wp_enqueue_style( 'fundee-slick', get_template_directory_uri().'/assets/css/slick.css');
    wp_enqueue_style( 'fundee-main', get_template_directory_uri().'/assets/css/main.css');
    wp_enqueue_style( 'fundee-responsive', get_template_directory_uri().'/assets/css/responsive.css');
    wp_enqueue_style( 'fundee-style', get_stylesheet_uri(), array(), '2020-02-28' );

    if(isset($fundee_redux_demo['rtl']) && $fundee_redux_demo['rtl']==1){
    wp_enqueue_style( 'rtl', get_template_directory_uri().'/rtl.css');  }

  	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
    wp_enqueue_script( 'comment-reply' );
    //Javascript
    wp_enqueue_script("modernizr", get_template_directory_uri()."/assets/js/vendor/modernizr-3.5.0.min.js",array(),false,true);
    wp_enqueue_script("/jquery-1.12.4", get_template_directory_uri()."/assets/js/vendor/jquery-1.12.4.min.js",array(),false,true);
    wp_enqueue_script("popper", get_template_directory_uri()."/assets/js/popper.min.js",array(),false,true);
    wp_enqueue_script("bootstrap", get_template_directory_uri()."/assets/js/bootstrap.min.js",array(),false,true);
    wp_enqueue_script("owl-carousel", get_template_directory_uri()."/assets/js/owl.carousel.min.js",array(),false,true);
    wp_enqueue_script("isotope-pkgd", get_template_directory_uri()."/assets/js/isotope.pkgd.min.js",array(),false,true);
    wp_enqueue_script("slick", get_template_directory_uri()."/assets/js/slick.min.js",array(),false,true);
    wp_enqueue_script("jquery-meanmenu", get_template_directory_uri()."/assets/js/jquery.meanmenu.min.js",array(),false,true);
    wp_enqueue_script("ajax-form", get_template_directory_uri()."/assets/js/ajax-form.js",array(),false,true);
    wp_enqueue_script("fundee-wow", get_template_directory_uri()."/assets/js/wow.min.js",array(),false,true);
    wp_enqueue_script("jquery-scrollUp", get_template_directory_uri()."/assets/js/jquery.scrollUp.min.js",array(),false,true);
    wp_enqueue_script("jquery-counterup", get_template_directory_uri()."/assets/js/jquery.counterup.min.js",array(),false,true);
    wp_enqueue_script("waypoints", get_template_directory_uri()."/assets/js/waypoints.min.js",array(),false,true);
    wp_enqueue_script("imagesloaded-pkgd", get_template_directory_uri()."/assets/js/imagesloaded.pkgd.min.js",array(),false,true);
    wp_enqueue_script("jquery-knob", get_template_directory_uri()."/assets/js/jquery.knob.js",array(),false,true);
    wp_enqueue_script("jquery-appear", get_template_directory_uri()."/assets/js/jquery.appear.js",array(),false,true);
    wp_enqueue_script("jquery-magnific-popup", get_template_directory_uri()."/assets/js/jquery.magnific-popup.min.js",array(),false,true);
    wp_enqueue_script("jquery-plugins", get_template_directory_uri()."/assets/js/plugins.js",array(),false,true);
    wp_enqueue_script("fundee-main", get_template_directory_uri()."/assets/js/main.js",array(),false,true);
}
add_action( 'wp_enqueue_scripts', 'fundee_theme_scripts_styles' );

add_theme_support( 'post-formats', array( 'image','quote','video','audio','gallery' ) );
//Custom Excerpt Function
function fundee_do_shortcode($content) {
    global $shortcode_tags;
    if (empty($shortcode_tags) || !is_array($shortcode_tags))
        return $content;
    $pattern = get_shortcode_regex();
    return preg_replace_callback( "/$pattern/s", 'do_shortcode_tag', $content );
}

add_filter('user_contactmethods', 'my_user_contactmethods');  
               
function my_user_contactmethods($user_contactmethods){  
    $user_contactmethods['facebook'] = 'Facebook Link';  
    $user_contactmethods['twitter'] = 'Twitter Link';
    $user_contactmethods['googleplus'] = 'Google Plus Link';  
    $user_contactmethods['instagram'] = 'Instagram Link';  
    $user_contactmethods['linkedin'] = 'Linkedin Link'; 
    $user_contactmethods['job'] = 'Job';  
  
  return $user_contactmethods;  
}   
// Widget Sidebar
function fundee_widgets_init() {
  	register_sidebar( array(
      'name'          => esc_html__( 'Primary Sidebar', 'fundee' ),
      'id'            => 'sidebar-1',        
  		'description'   => esc_html__( 'Appears in the sidebar section of the site.', 'fundee' ),        
  		'before_widget' => '<div class="widget mb-60 %2$s" id="%1$s">',        
  		'after_widget'  => '</div>',        
  		'before_title'  => '<div class="widget-title-box mb-35"><h3 class="widget-title-2">
                                     ',        
  		'after_title'   => '</h3></div>'
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer One Widget', 'fundee' ),
      'id'            => 'footer-area-1',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '',
      'after_widget'  => '',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Two Widget', 'fundee' ),
      'id'            => 'footer-area-2',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Three Widget', 'fundee' ),
      'id'            => 'footer-area-3',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Four Widget', 'fundee' ),
      'id'            => 'footer-area-4',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer One Widget Home 1', 'fundee' ),
      'id'            => 'footer-area-home1-1',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Two Widget Home 1', 'fundee' ),
      'id'            => 'footer-area-home1-2',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Three Widget Home 1', 'fundee' ),
      'id'            => 'footer-area-home1-3',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Four Widget Home 1', 'fundee' ),
      'id'            => 'footer-area-home1-4',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer One Widget Home 2', 'fundee' ),
      'id'            => 'footer-area-home2-1',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Two Widget Home 2', 'fundee' ),
      'id'            => 'footer-area-home2-2',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Three Widget Home 2', 'fundee' ),
      'id'            => 'footer-area-home2-3',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
    register_sidebar( array(
      'name'          => esc_html__( 'Footer Four Widget Home 2', 'fundee' ),
      'id'            => 'footer-area-home2-4',
      'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'fundee' ),
      'before_widget' => '<div id="%1$s">',
      'after_widget'  => '</div>',
      'before_title'  => ' ',
      'after_title'   => ' ',
    ) );
}
add_action( 'widgets_init', 'fundee_widgets_init' );
//function tag widgets
function fundee_tag_cloud_widget($args) {
  	$args['number'] = 0; //adding a 0 will display all tags
  	$args['largest'] = 18; //largest tag
  	$args['smallest'] = 11; //smallest tag
  	$args['unit'] = 'px'; //tag font unit
  	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
  	$args['exclude'] = array(20, 80, 92); //exclude tags by ID
  	return $args;
}
add_filter( 'widget_tag_cloud_args', 'fundee_tag_cloud_widget' );
function fundee_excerpt() {
  $fundee_redux_demo = get_option('redux_demo');
  if(isset($fundee_redux_demo['blog_excerpt'])){
    $limit = $fundee_redux_demo['blog_excerpt'];
  }else{
    $limit = 50;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function fundee_excerpt2() {
  $fundee_redux_demo = get_option('redux_demo');
  if(isset($fundee_redux_demo['blog_excerpt2'])){
    $limit = $fundee_redux_demo['blog_excerpt2'];
  }else{
    $limit = 50;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function fundee_excerpt3() {
  $fundee_redux_demo = get_option('redux_demo');
  if(isset($fundee_redux_demo['courses_excerpt'])){
    $limit = $fundee_redux_demo['courses_excerpt'];
  }else{
    $limit = 50;
  }
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
function fundee_search_form( $form ) {
    $form = '
        <form action="' . esc_url(home_url('/')) . '">
            <input type="text" class="s-input-home" name="s" required value="' . get_search_query() . '" placeholder="'.esc_attr__('Search…', 'fundee').'">
            <button class="btn-s-input" type="submit"><i class="fa fa-search"></i></button>
        </form>
	';
    return $form;
}
add_filter( 'get_search_form', 'fundee_search_form' );
function fundee_theme_comment($comment, $args, $depth) {
    //echo 's';
   $GLOBALS['comment'] = $comment; ?>
    <?php if(get_avatar($comment,$size='100' )!=''){?>
<li>
    <div class="comments-box">
        <div class="comments-avatar">
            <?php echo get_avatar($comment,$size='100');?>
        </div>
        <div class="comments-text">
            <div class="avatar-name">
                <h5><?php printf( get_comment_author_link()) ?></h5>
                <span><?php the_time(get_option( 'date_format' ));?></span>
                <div class="reply"><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></div>
            </div>
            <?php comment_text() ?>
        </div>
    </div>
</li>       
  <?php }else{?>
<li>
    <div class="comments-box">
        <div class="comments-text">
            <div class="avatar-name">
                <h5><?php printf( get_comment_author_link()) ?></h5>
                <span><?php the_time(get_option( 'date_format' ));?></span>
                <div class="reply"><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></div>
            </div>
            <?php comment_text() ?>
        </div>
    </div>
</li> 
<?php }?>

<?php
}

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'fundee_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
 
 
function fundee_theme_register_required_plugins() {
    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(
        // This is an example of how to include a plugin from the WordPress Plugin Repository.
      array(
            'name'      => esc_html__( 'One Click Demo Import', 'fundee' ),
            'slug'      => 'one-click-demo-import',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Classic Editor', 'fundee' ),
            'slug'      => 'classic-editor',
            'required'  => true,
        ), 
      array(
            'name'      => esc_html__( 'Widget Importer & Exporter', 'fundee' ),
            'slug'      => 'widget-importer-&-exporter',
            'required'  => true,
        ), 
      array(
            'name'                     => esc_html__( 'Contact Form 7', 'fundee' ),
            'slug'                     => 'contact-form-7',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/contact-form-7.zip',
        ),
      array(
            'name'                     => esc_html__( 'Fundee Common', 'fundee' ),
            'slug'                     => 'fundee-common',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/fundee-common.zip',
        ),
      array(
            'name'                     => esc_html__( 'Elementor', 'fundee' ),
            'slug'                     => 'elementor',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/elementor.zip',
        ),
      array(
            'name'                     => esc_html__( 'Fundee Elementor', 'fundee' ),
            'slug'                     => 'fundee-elementor',
            'required'                 => true,
            'source'                   => get_template_directory() . '/framework/plugins/fundee-elementor.zip',
        ),
    );
    /**
     * Array of configuration settings. Amend each line as needed.
     * If you want the default strings to be available under your own theme domain,
     * leave the strings uncommented.
     * Some of the strings are added into a sprintf, so see the comments at the
     * end of each line for what each argument will be.
     */
    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'fundee' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'fundee' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'fundee' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'fundee' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'fundee' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'fundee' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'fundee' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'fundee' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'fundee' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'fundee' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'fundee' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'fundee' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'fundee' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'fundee' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'fundee' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'fundee' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'fundee' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );
    tgmpa( $plugins, $config );
}

function fundee_import_files() {
    return array(
        array(
            'import_file_name'           => 'Demo Import Fundee',
            'import_file_url'            => 'http://shtheme.com/import/fundee/content.xml',
            'import_widget_file_url'     => 'http://shtheme.com/import/fundee/widget.json',
            'import_notice'              => esc_html__( 'Import data example fundee', 'fundee' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'fundee_import_files' );



function fundee_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Menu 1', 'primary' );
    

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
            
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home 1' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'fundee_after_import_setup' );


?>