<!doctype html>
<html <?php language_attributes(); ?>>
<?php $fundee_redux_demo = get_option('redux_demo'); ?>
<head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
        ?>
    <link rel="shortcut icon" href="<?php if(isset($fundee_redux_demo['favicon']['url'])){?><?php echo esc_url($fundee_redux_demo['favicon']['url']); ?><?php }?>">
    <?php }?>
        <?php wp_head(); ?> 
</head>
<body <?php body_class(); ?>>
<!--[if lt IE 8]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->


    <!-- < NAVIGATION WITH BACKGROUND COLOR NAVBAR >............................................ -->
<!-- removed navbar-toggleable-md because responsive issues. Find out why ..... -->


    <!-- start page-wrapper -->
<div id="preloader">
<div class="preloader">
    <span></span>
    <span></span>
</div>
</div>
<!-- preloader end  -->
<!-- header-start -->
<header>
    <div class="header-top-area black-bg">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8 col-md-5 col-8 d-flex align-items-center">
                    <div class="header-top-wrapper">
                        <div class="header-info">
                            <?php if($fundee_redux_demo['time'] != ''){?>
                            <span class="mail-header-icon"><i class="far fa-clock"></i><?php echo esc_attr($fundee_redux_demo['time']);?></span>
                            <?php } ?>
                            <?php if($fundee_redux_demo['email'] != ''){?>
                            <span><i class="far fa-envelope-open"></i> <?php echo esc_attr($fundee_redux_demo['email']);?></span>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-4 col-md-7 col-4">
                    <div class="header-top-right">
                        <div class="header-login f-right">
                            <a href="#"><i class="far fa-user"></i> Login</a>
                        </div>
                        <div class="header-icon f-right d-none d-md-block">
                            <?php if($fundee_redux_demo['facebook'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['facebook']);?>"><i class="fab fa-facebook-f"></i></a>
                            <?php } ?>
                            <?php if($fundee_redux_demo['twitter'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['twitter']);?>"><i class="fab fa-twitter"></i></a>
                            <?php } ?>
                            <?php if($fundee_redux_demo['google'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['google']);?>"><i class="fab fa-google-plus-g"></i></a>
                            <?php } ?>
                            <?php if($fundee_redux_demo['dribbble'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['dribbble']);?>"><i class="fab fa-dribbble"></i></a>
                            <?php } ?>
                            <?php if($fundee_redux_demo['linkedin'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['linkedin']);?>"><i class="fab fa-linkedin"></i></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="sticky-header" class="main-menu-area green-bg">
        <div class="container">
            <div class="row">
                <div class="col-xl-3 col-lg-2 d-flex align-items-center">
                    <?php if(isset($fundee_redux_demo['logo_white']['url']) && $fundee_redux_demo['logo_white']['url'] != ''){?> 
                    <div class="logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($fundee_redux_demo['logo_white']['url']); ?>" alt="" /></a>
                    </div>
                    <?php }else{?>
                    <div class="logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo get_template_directory_uri();?>/assets/img/logo/logo-white.png" alt="" /></a>
                    </div>
                    <?php } ?> 
                </div>
                <div class="col-xl-6 col-lg-7">
                    <div class="main-menu text-center">
                        <nav id="mobile-menu">
                            <?php 
                            wp_nav_menu( 
                                array( 
                                    'theme_location' => 'primary',
                                    'container' => '',
                                    'menu_class' => '', 
                                    'menu_id' => '',
                                    'menu'            => '',
                                    'container_class' => '',
                                    'container_id'    => '',
                                    'echo'            => true,
                                     'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                     'walker'            => new fundee_wp_bootstrap_navwalker(),
                                    'before'          => '',
                                    'after'           => '',
                                    'link_before'     => '',
                                    'link_after'      => '',
                                    'items_wrap'      => '<ul class=" %2$s" >%3$s</ul>',
                                    'depth'           => 0,        
                                )
                            ); ?>
                        </nav>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 d-none d-lg-block">
                    <div class="header-right">
                        <div class="header-right-info f-right d-none d-lg-block">
                            <div class="header-right-text text-right f-left">
                                <?php if($fundee_redux_demo['title_phone'] != ''){?>
                                <h5><?php echo esc_attr($fundee_redux_demo['title_phone']);?></h5>
                                <?php } ?>
                                <?php if($fundee_redux_demo['phone'] != ''){?>
                                <span><?php echo esc_attr($fundee_redux_demo['phone']);?></span>
                                <?php } ?>
                            </div>
                            <?php if($fundee_redux_demo['icon_phone'] != ''){?>
                            <div class="heder-right-icon f-right">
                                <img src="<?php echo esc_url($fundee_redux_demo['icon_phone']['url']); ?>" alt="">
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="mobile-menu"></div>
                </div>
            </div>
        </div>
    </div>
</header>
<main>