<!doctype html>
<html <?php language_attributes(); ?>>
<?php $fundee_redux_demo = get_option('redux_demo'); ?>
<head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
        ?>
    <link rel="shortcut icon" href="<?php if(isset($fundee_redux_demo['favicon']['url'])){?><?php echo esc_url($fundee_redux_demo['favicon']['url']); ?><?php }?>">
    <?php }?>
        <?php wp_head(); ?> 
</head>
<body <?php body_class(); ?>>
<!--[if lt IE 8]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->


    <!-- < NAVIGATION WITH BACKGROUND COLOR NAVBAR >............................................ -->
<!-- removed navbar-toggleable-md because responsive issues. Find out why ..... -->


    <!-- start page-wrapper -->
<div id="preloader">
<div class="preloader">
    <span></span>
    <span></span>
</div>
</div>
<!-- preloader end  -->
<!-- header-start -->
<header class="header-transparent">
    <div class="main-menu-area menu-2 pl-155 pr-115">
        <div class="container-fluid">
            <div class="row d-flex align-items-center">
                <div class="col-xl-2 col-lg-3">
                    <?php if(isset($fundee_redux_demo['logo']['url']) && $fundee_redux_demo['logo']['url'] != ''){?> 
                    <div class="logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($fundee_redux_demo['logo']['url']); ?>" alt="" /></a>
                    </div>
                    <?php }else{?>
                    <div class="logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo get_template_directory_uri();?>/assets/img/logo/black-logo.png" alt="" /></a>
                    </div>
                    <?php } ?> 
                </div>
                <div class="col-xl-4 col-lg-4 d-none d-xl-block">
                    <div class="header-02-wrapper">
                        <?php if($fundee_redux_demo['phone'] != ''){?>
                        <div class="header-02-info mr-60 f-left">
                            <a href="#"><i class="far fa-phone"></i> <?php echo esc_attr($fundee_redux_demo['phone']);?></a>
                        </div>
                        <?php } ?>
                        <div class="header-lang mr-60 pos-rel f-left">
                            <div class="lang-icon">
                                <img src="assets/img/icon/flag.png" alt="">
                                <a href="#">Eng <i class="far fa-angle-down"></i></a>
                            </div>
                            <ul class="header-lang-list">
                                <li><a href="#">USA</a></li>
                                <li><a href="#">UK</a></li>
                                <li><a href="#">CA</a></li>
                                <li><a href="#">AU</a></li>
                            </ul>
                        </div>
                        <div class="header-icon header-02-icon f-left">
                            <?php if($fundee_redux_demo['facebook'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['facebook']);?>"><i class="fab fa-facebook-f"></i></a>
                            <?php } ?>
                            <?php if($fundee_redux_demo['twitter'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['twitter']);?>"><i class="fab fa-twitter"></i></a>
                            <?php } ?>
                            <?php if($fundee_redux_demo['google'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['google']);?>"><i class="fab fa-google-plus-g"></i></a>
                            <?php } ?>
                            <?php if($fundee_redux_demo['dribbble'] != ''){?>
                            <a href="<?php echo esc_attr($fundee_redux_demo['dribbble']);?>"><i class="fab fa-dribbble"></i></a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-9">
                    <div class="search-icon f-right d-none d-lg-block">
                        <a href="#" data-toggle="modal" data-target="#search-modal"><i class="far fa-search"></i></a>
                    </div>
                    <div class="main-menu f-left f-right">
                        <nav id="mobile-menu">
                            <?php 
                            wp_nav_menu( 
                                array( 
                                    'theme_location' => 'primary',
                                    'container' => '',
                                    'menu_class' => '', 
                                    'menu_id' => '',
                                    'menu'            => '',
                                    'container_class' => '',
                                    'container_id'    => '',
                                    'echo'            => true,
                                     'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                     'walker'            => new fundee_wp_bootstrap_navwalker(),
                                    'before'          => '',
                                    'after'           => '',
                                    'link_before'     => '',
                                    'link_after'      => '',
                                    'items_wrap'      => '<ul class=" %2$s" >%3$s</ul>',
                                    'depth'           => 0,        
                                )
                            ); ?>
                        </nav>
                    </div>
                </div>
                <div class="col-12">
                    <div class="mobile-menu"></div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- header-start -->

<main>