<!doctype html>
<html <?php language_attributes(); ?>>
<?php $fundee_redux_demo = get_option('redux_demo'); ?>
<head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
        ?>
    <link rel="shortcut icon" href="<?php if(isset($fundee_redux_demo['favicon']['url'])){?><?php echo esc_url($fundee_redux_demo['favicon']['url']); ?><?php }?>">
    <?php }?>
        <?php wp_head(); ?> 
</head>
<body>
<!--[if lt IE 8]>
<p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->


    <!-- < NAVIGATION WITH BACKGROUND COLOR NAVBAR >............................................ -->
<!-- removed navbar-toggleable-md because responsive issues. Find out why ..... -->


    <!-- start page-wrapper -->
 <header>
    <div class="header-area header-transparent header-space pt-45 pb-45">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-3 col-lg-3 col-md-5 d-flex align-items-lg-center">
                    <div class="logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>"> <img src="<?php echo esc_url($fundee_redux_demo['logo']['url']); ?>" alt=""> </a>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 d-none d-lg-block">
                    <div class="main-menu contract-menu">
                        <nav id="mobile-menu">
                            <?php 
                            wp_nav_menu( 
                                array( 
                                    'theme_location' => 'primary',
                                    'container' => '',
                                    'menu_class' => '', 
                                    'menu_id' => '',
                                    'menu'            => '',
                                    'container_class' => '',
                                    'container_id'    => '',
                                    'echo'            => true,
                                     'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                     'walker'            => new fundee_wp_bootstrap_navwalker(),
                                    'before'          => '',
                                    'after'           => '',
                                    'link_before'     => '',
                                    'link_after'      => '',
                                    'items_wrap'      => '<ul class="navigation clearfix %2$s" >%3$s</ul>',
                                    'depth'           => 0,        
                                )
                            ); ?>
                        </nav>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-3 col-md-7 d-flex align-items-center justify-content-end">
                    <div class="header-btn f-right d-none d-md-block">
                        <a class="btn" href="<?php echo esc_attr($fundee_redux_demo['link_sign_in']);?>"><i class="far fa-user"></i> <?php echo esc_attr($fundee_redux_demo['sign_in']);?></a>
                    </div>
                    <div class="bar f-right d-none d-lg-block">
                        <a class="info-bar" href="javascript:void(0);"><i class="far fa-bars"></i></a>
                    </div>
                </div>
                <div class="col-12">
                    <div class="mobile-menu"></div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- header start -->
<div class="extra-info">
    <div class="close-icon">
        <button>
            <i class="far fa-window-close"></i>
        </button>
    </div>
    <div class="logo-side mb-30">
        <a href="<?php echo esc_url(home_url('/')); ?>">
            <img src="<?php echo esc_url($fundee_redux_demo['logo_2']['url']); ?>" alt="" />
        </a>
    </div>
    <?php if ( is_active_sidebar( 'sidebar-2' ) ) : ?>
        <?php dynamic_sidebar( 'sidebar-2' ); ?>
    <?php endif; ?> 
</div>


<main>