<?php
/*
 * Template Name: Blog Grid
 * Description: A Page Template with a Page Builder design.
 */
$fundee_redux_demo = get_option('redux_demo');
get_header('home1'); ?>

<?php if(isset($fundee_redux_demo['blog_image']['url']) && $fundee_redux_demo['blog_image']['url'] != ''){?> 
<div class="breadcrumb-area pt-150 pb-155" style="background-image:url(<?php echo esc_url($fundee_redux_demo['blog_image']['url']);?>)">
<?php }else{?>
<div class="breadcrumb-area pt-150 pb-155" style="background-image:url(<?php echo get_template_directory_uri();?>/assets/img/bg/bg-13.jpg)">
<?php } ?> 
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="breadcrumb-text text-center">
                    <h1>
                    	<?php if(isset($fundee_redux_demo['blog_grid_title'])){?>
                        <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['blog_grid_title']));?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Blog Grid View', 'fundee' ); } ?>
                	</h1>
                    <ul class="breadcrumb-menu">
                        <li>
                        	<a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__( 'Home', 'fundee' );?></a>
                        </li>
                        <li><span>
	                        	<?php if(isset($fundee_redux_demo['blog_grid_title'])){?>
		                        <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['blog_grid_title']));?>
		                        <?php }else{?>
		                        <?php echo esc_html__( 'Blog Grid View', 'fundee' ); } ?>
                        	</span>
                    	</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb-area-end -->

<!-- blog-area-start -->
<?php if(isset($fundee_redux_demo['backround_image_grid']['url']) && $fundee_redux_demo['backround_image_grid']['url'] != ''){?> 
<div class="blog-grid-area pt-130 pb-130" style="background-image:url(<?php echo esc_url($fundee_redux_demo['backround_image_grid']['url']);?>)">
<?php }else{?>
<div class="blog-grid-area pt-130 pb-130" style="background-image:url(http://shtheme.org/demosd/amassivx/wp-content/uploads/2020/04/blogbg.png)">
<?php } ?> 
    <div class="container">
        <div class="row">
            <?php $args = array(    
                'paged' => $paged,
                'post_type' => 'post',
                );
            $wp_query = new WP_Query($args);
            while (have_posts()): the_post(); 
            $image_grid = get_post_meta(get_the_ID(),'_cmb_image_grid', true);
            ?>
            <div class="col-xl-4 col-lg-4 col-md-6">
                <div class="blog-wrapper mb-80">
                    <div class="blog-img">
                        <a href="<?php the_permalink();?>"><img src="<?php echo esc_url($image_grid);?>" alt=""></a>
                    </div>
                    <div class="blog-content blog-02-content">
                        <div class="blog-meta">
                            <span><i class="far fa-calendar-alt"></i> <?php the_time(get_option( 'date_format' ));?></span>
                            <span><i class="far fa-comment"></i> <?php comments_number( esc_html__('0 Comments', 'moral'), esc_html__('1 Comment', 'moral'), esc_html__('% Comments', 'moral') ); ?></span>
                        </div>
                        <div class="blog-title">
                            <h3><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h3>
                        </div>
                        <p> 
                        	<?php if(isset($fundee_redux_demo['blog_excerpt2'])){?>
                            <?php echo esc_attr(fundee_excerpt2($fundee_redux_demo['blog_excerpt2'])); ?>
                            <?php }else{?>
                            <?php echo esc_attr(fundee_excerpt2(50)); } ?>
                        </p>
                        <a class="btn green-btn" href="<?php the_permalink();?>">
                        	<?php if(isset($fundee_redux_demo['read_more'])){?>
                            <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['read_more']));?>
                            <?php }else{?>
                            <?php echo esc_html__( 'Read more', 'fundee' ); } ?>
                            <i class="far fa-long-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
            
            
        </div>
        <?php if(paginate_links( $pagination ) != '') { ?>
        <div class="row">
            <div class="col-xl-12">
                <div class="basic-pagination mt-10 text-center">
                    <?php 
                        $pagination = array(
                        'base'      => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
                        'format'    => '',
                        'prev_text' => wp_specialchars_decode(esc_html__( '<i class="fas fa-chevron-left"></i>', 'piohost' ),ENT_QUOTES),
                        'next_text' => wp_specialchars_decode(esc_html__( '<i class="fas fa-chevron-right"></i>', 'piohost' ),ENT_QUOTES),
                        'type'      => 'list',
                        'end_size'    => 3,
                        'mid_size'    => 3
                    );
                    if(paginate_links( $pagination ) != ''){
                        $return =  paginate_links( $pagination );
                        echo str_replace( "<ul class='page-numbers'>", '<ul class="styled-pagination">', $return );
                    }
                    ?>
                </div>
            </div>
        </div>
    	<?php } ?>
    </div>
</div>

    <?php
get_footer();
?>