<?php
   $fundee_redux_demo = get_option('redux_demo');
   get_header('home1'); 
?>
<?php 
    while (have_posts()): the_post();
?>
<?php if(isset($fundee_redux_demo['background_event_image']['url']) && $fundee_redux_demo['blog_single_image']['url'] != ''){?>
<div class="breadcrumb-area pt-150 pb-155" style="background-image:url(<?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['background_event_image']));?>)">
<?php }else{?>
<div class="breadcrumb-area pt-150 pb-155" style="background-image:url(<?php echo get_template_directory_uri();?>/assets/img/bg/bg-13.jpg)">
<?php } ?>
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="breadcrumb-text text-center">
                    <h1>
                        <?php if(isset($fundee_redux_demo['event_detail'])){?>
                        <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['event_detail']));?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Event Details', 'fundee' ); } ?>
                    </h1>
                    <ul class="breadcrumb-menu">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>">
                                <?php echo esc_html__( 'Home', 'fundee' );?>
                            </a></li>
                        <li><span><?php if(isset($fundee_redux_demo['event_detail'])){?>
                        <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['event_detail']));?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Event Details', 'fundee' ); } ?></span></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb-area-end -->

<!-- our-events-details-area-start -->
<div class="our-events-details-area pt-130 pb-100">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="our-events-details-wrapper">
                    <?php if (get_post_thumbnail_id() !='')  { ?>
                    <div class="our-events-details-img mb-50">
                        <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="">
                    </div>
                    <?php } ?>
                    <div class="row mb-45">
                        <div class="col-xl-8 col-lg-8 mb-30">
                            <div class="blog-details-text">
                                <h1><?php the_title(); ?></h1>
                                <?php the_content(); ?>
                                <?php wp_link_pages( array(
                                    'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'webfix' ),
                                    'after'       => '</div>',
                                    'link_before' => '<p class="page-number">',
                                    'link_after'  => '</p>',
                                ) ); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 mb-30">
                                <div class="our-events-details-img">
                                    <img src="<?php echo get_template_directory_uri();?>/assets/img/event/002.jpg" alt="">
                                </div>
                            </div>
                            <div class="col-xl-8 col-lg-8 mb-30">
                                <div class="our-events-details-img">
                                    <img src="<?php echo get_template_directory_uri();?>/assets/img/event/003.jpg" alt="">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 mb-30">
                                <div class="our-events-details-img">
                                    <img src="<?php echo get_template_directory_uri();?>/assets/img/event/004.jpg" alt="">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 mb-30">
                                <div class="our-events-details-img">
                                    <img src="<?php echo get_template_directory_uri();?>/assets/img/event/005.jpg" alt="">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 mb-30">
                                <div class="our-events-details-img">
                                    <img src="<?php echo get_template_directory_uri();?>/assets/img/event/006.jpg" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</div>
<!-- our-events-details-area-end -->

<!-- cta-area-start -->
<div class="cta-area pt-120 pb-130" style="background-image:url(<?php echo get_template_directory_uri();?>/assets/img/bg/bg-15.jpg)">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-8 offset-lg-2 offset-xl-2">
                <div class="cta-02-wrapper text-center">
                    <div class="cta-content">
                        <h1>We are always waiting for your helping hands, human service
                            is the greatest religion
                            </h1>
                        <div class="cta-button">
                            <a class="btn" href="#">donate now <i class="far fa-long-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endwhile; ?>
    <!-- FOOTER -->
<?php
    get_footer();
?>

